import { assign, createMachine } from 'xstate';
import { fetchCountries } from '../Utils/api';

const fillCountries = {
  initial: 'loading',
  states: {
    loading: {
      invoke: {
        id: 'getCountries',
        src: () => fetchCountries,
        onDone: {
          target: 'success',
          actions: assign({
            countries: (_, event) => event.data,
          }),
        },
        onError: {
          target: 'failure',
          actions: assign({
            error: 'Fallo el request',
          }),
        },
      }
    },
    success: {},
    failure: {
      on: {
        RETRY: { target: 'loading', },
      },
    },
  }
}

const bookingMachine = createMachine({
  id: 'buy plane tickets',
  initial: 'initial',
  context: {
    passengers: [],
    selectedCountry: '',
    countries: [],
    erro: '',
  },
  states: {
    initial: {
      on: {
        START: {
          target: 'search',
        },
      },
    },
    search: {
      on: {
        CONTINUE: {
          target: 'passengers',
          actions: assign({
            selectedCountry: (_, event) =>
              event.selectedCountry
          }),
        },
        CANCEL: {
          target: 'initial',
          actions: 'cleanContext',
        },
      },
      ...fillCountries,
    },
    passengers: {
      on: {
        DONE: {
          target: 'tickets',
          cond: 'moreThanOnePassenger',
        },
        CANCEL: {
          target: 'initial',
          actions: 'cleanContext',
        },
        ADD: {
          target: 'passengers',
          actions: assign(
            //{passengers: (context, event) => [...context.passengers, (event.newPassenger)]}
            (context, event) => context.passengers.push(event.newPassenger)
          ),
        }
      },
    },
    tickets: {
      after: {
        5000: {
          target: 'initial',
          actions: 'cleanContext',
        }
      },
      on: {
        FINISH: 'initial',
      },
      CANCEL: {
          target: 'initial',
          actions: 'cleanContext',
      },
    },
  },

},
  {
    actions: {
      cleanContext: assign({
        selectedCountry: '',
        passengers: [],
      }),
    },
    guards: {
      moreThanOnePassenger: (context) => context.passengers.length > 0
    }
  },
)

export default bookingMachine;
